/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.quest.AbstractAreaBasedQuest;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.KillInAreaData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.common.quests.trigger.TriggerResponseStatus;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class KillInAreaQuest
extends AbstractAreaBasedQuest<KillInAreaData> {
    public static final IQuestFactory<KillInAreaData, KillInAreaQuest> FACTORY = IQuestFactory.of(KillInAreaQuest::new, KillInAreaQuest::new);
    private int killCount;

    public KillInAreaQuest(QuestScheme<KillInAreaData> scheme, UUID traderId) {
        super(scheme, traderId);
    }

    public KillInAreaQuest(QuestDeserializationContext<KillInAreaData> context) {
        super(context);
    }

    @Override
    protected void registerAdditionalTriggers(Quest.ITriggerRegistration registration) {
        registration.addEntry(Trigger.ENTITY_KILLED, this::onEntityKilled, this::handleSuccessfulKill);
    }

    @Override
    protected void fillDataModel(QuestDisplayDataModel model) {
        model.addQuestHeader(this, false);
        model.addInformationRow((ITextComponent)this.getScheme().getDisplayInfo().getInfo(), this, q -> new StringTextComponent(q.killCount + "/" + ((KillInAreaData)q.getActiveData()).getKillTarget()));
        this.fillAreaDataModel(model);
        model.addConditionDisplay(this);
    }

    @Override
    protected void writeAdditionalData(CompoundNBT nbt) {
        nbt.func_74768_a("killCount", this.killCount);
    }

    @Override
    protected void readAddtionalData(CompoundNBT nbt) {
        this.killCount = nbt.func_74762_e("killCount");
    }

    private TriggerResponseStatus onEntityKilled(Trigger trigger, IPropertyReader reader) {
        KillInAreaData data;
        PlayerEntity player = reader.getProperty(QuestProperties.PLAYER);
        Entity entity = (Entity)reader.getProperty(QuestProperties.ENTITY);
        if (this.area.isInArea((Entity)player) && (data = (KillInAreaData)this.getActiveData()).getEntityFilter().test(entity)) {
            return TriggerResponseStatus.OK;
        }
        return TriggerResponseStatus.PASS;
    }

    private void handleSuccessfulKill(Trigger trigger, IPropertyReader reader) {
        if (++this.killCount >= ((KillInAreaData)this.getActiveData()).getKillTarget()) {
            this.setStatus(QuestStatus.COMPLETED);
        }
        this.trySyncClient();
    }

    @Override
    protected void handleSuccessfulTick(Trigger trigger, IPropertyReader reader) {
    }
}

